<?php 
include_once(PCMA_DIR . '/default_mail_texts.php'); 
$ml_key = PCMA_ML;


// user categories
$user_cats = get_terms('pg_user_categories', 'orderby=name&hide_empty=0'); 

// WP pages list
$pages = pc_static::get_pages(); 


// given an array - print mail placeholders legend block
function pcma_phs_legend($ph) {
	$trs = ''; 	
	foreach($ph as $code => $txt) {
		$trs .= '<tr><td>'.$code.'</td><td><p class="lcwp_sf_note">'. $txt .'</p></td></tr>';
	}
	
	return array(
		'label'		=> __('Allowed variables for title and text', PCMA_ML) .'<p class="lcwp_sf_note">'. __('Remember you can use <a href="http://www.lcweb.it/privatecontent/user-data-add-on" target="_blank">User Data add-on</a> shortcode to insert custom fields into the mail text', PCMA_ML) .'</p>',
		'type'		=> 'label_message',
		'content'	=> '<table class="pcma_placholders_legend">'. $trs .'</table>'
	);
}



// tab status bullet 
function pcma_settings_tab_bullet($opt_name) {
    $enabled = false;
    foreach((array)$opt_name as $on) {
        if(get_option($on)) {
            $enabled = true;
            break;
        }
    }
    
    $color = ($enabled) ? '#7fc241' : 'orange';
    $legend = ($enabled) ? esc_attr__('system enabled', PCMA_ML) : esc_attr__('system disabled', PCMA_ML);
    return '<i title="'. $legend .'" style="color: '. $color .';">&bull;</i>';
}



////////////////////////////////////////////////////////////



// PCMA-FILTER - manipulate settings tabs
$tabs = array(
	'mail_config' 	=> __('E-mail Config', $ml_key),
	'users_verif' 	=> __('Users Verification', $ml_key) . pcma_settings_tab_bullet('pcma_mv_enable'),
	'admin_notif'	=> __('Admin Notifier', $ml_key) . pcma_settings_tab_bullet(array('pcma_nnu_enable', 'pcma_dun_enable')),
	'approved_notif'=> __('Approval Notifier', $ml_key)  . pcma_settings_tab_bullet('pcma_nau_enable'),
	'welcome_mess' 	=> __('Welcome Message', $ml_key) . pcma_settings_tab_bullet('pcma_wm_enable'),
    'goodbye_mess'  => __('Goodbye Message', $ml_key) . pcma_settings_tab_bullet('pcma_gm_enable'),
	'import_mess' 	=> __('Import Notifier', $ml_key) . pcma_settings_tab_bullet('pcma_niu_enable'),
	'psw_recovery' 	=> __('Password Recovery', $ml_key) . pcma_settings_tab_bullet('pcma_psw_recovery'),
    'user_pp_update_notif' 	=> __('User Private Page Update Notifier', $ml_key),
	'mailchimp' 	=> __('Mailchimp', $ml_key) . pcma_settings_tab_bullet('pcma_mc_apikey'),
);
$GLOBALS['pcma_settings_tabs'] = apply_filters('pcma_settings_tabs', $tabs);	




// STRUCTURE
/* tabs index => array( 
	'sect_id' => array(
		'sect_name'	=> name
		'fields'	=> array(
			...
		)
	)
   )
*/

$structure = array();


// MAIL CONFIGURATION
$structure['mail_config'] = array(
	'mail_data' => array(
		'sect_name'	=>  __('E-mail Data <small>(mandatory to use the add-on)</small>', $ml_key),
		'fields' 	=> array(
			
			'pcma_from_name' => array(
				'label' 	=> __('"Sent From" name', $ml_key),
				'type'		=> 'text',
				'def'		=> get_bloginfo('name'),
				'required'	=> true,
				'maxlen'	=> 100,
				'note'		=> __('Name shown in "Sent From" field of the e-mail', $ml_key),
			),
			'pcma_from_mail' => array(
				'label' 	=> __('"Sent From" e-mail', $ml_key),
				'type'		=> 'text',
				'def'		=> get_bloginfo('admin_email'),
				'required'	=> true,
				'subtype'	=> 'email',
				'maxlen'	=> 100,
				'note'		=> __('E-mail address shown in "Sent From" field of the e-mail', $ml_key),
			),
			'pcma_reply_to_name' => array(
				'label' 	=> __('"Reply To" name', $ml_key),
				'type'		=> 'text',
				'def'		=> get_bloginfo('admin_email'),
				'required'	=> true,
				'maxlen'	=> 100,
				'note'		=> __('Name shown in the "Reply To" field of the e-mail', $ml_key),
			),
			'pcma_reply_to_mail' => array(
				'label' 	=> __('"Reply To" e-mail', $ml_key),
				'type'		=> 'text',
				'def'		=> get_bloginfo('admin_email'),
				'required'	=> true,
				'subtype'	=> 'email',
				'maxlen'	=> 100,
				'note'		=> __('E-mail address shown in the "Reply To" field of the e-mail', $ml_key),
			),
		),
	),
		
    
    'outgoing_mails_threshold' => array(
		'sect_name'	=>  __('Outgoing bulk e-mails limit <small>(mandatory to use e-mail campaigns)</small>', $ml_key),
		'fields' 	=> array(
			
			'pcma_bulk_mail_limit_num' => array(
				'label' 	=> __("Outgoing bulk e-mails limit", $ml_key),
				'type'		=> 'slider',
				'min_val'	=> 100,
				'max_val'	=> 50000,	
				'step'		=> 100,
				'value'		=> '',
				'def'		=> 400,
                'respect_limits' => false,
				'note'		=> '',
			),
            'pcma_bulk_mail_limit_type' => array(
				'label' 	=> __('E-mails limit is indented', $ml_key),
				'type'		=> 'select',
				'val' 		=> array(
                    'hourly'    => __('per hour', $ml_key),
                    'daily'     => __('per day', $ml_key),
                    'monthly'   => __('monthly', $ml_key),
                ),
				'note'		=> '',
            ),
            'outgoing_mails_threshold_note' => array(
				'type'      => 'message',
				'content'   => '<h4>'. __('NB: is suggested to set a number lower than the limit to prevent everyday e-mails block in case you hit the threshold</h4>', $ml_key),
			),
		),
	),
    
		
	'smtp' => array(
		'sect_name'	=>  __('SMTP configuration', $ml_key),
		'fields' 	=> array(
			
			'pcma_use_smtp' => array(
				'label' => __('Use SMTP to send e-mails?', $ml_key),
				'type'	=> 'checkbox',
				'note'	=> __('If checked, use the SMTP protocol to send e-mails (use only if required by your server)', $ml_key),
			),
			'pcma_smtp_host' => array(
				'label' => __('SMTP host', $ml_key),
				'type'	=> 'text',
				
				'js_vis'=> array(
					'linked_field' 	=> 'pcma_use_smtp',
					'condition'		=> true
				)
			),
			'pcma_smtp_port' => array(
				'label' 	=> __('SMTP port', $ml_key),
				'type'		=> 'text',
				'subtype' 	=> 'int',
				'maxlen'	=> 4,
				
				'js_vis'=> array(
					'linked_field' 	=> 'pcma_use_smtp',
					'condition'		=> true
				)
			),
			'pcma_smtp_user' => array(
				'label' 	=> __('E-mail username', $ml_key),
				'type'		=> 'text',
				'def'		=> get_bloginfo('name'),
				'maxlen'	=> 100,
				'note'		=> __('Username to access the e-mail (normally is the e-mail address itself)', $ml_key),
				
				'js_vis'=> array(
					'linked_field' 	=> 'pcma_use_smtp',
					'condition'		=> true
				)
			),
			'pcma_smtp_psw' => array(
				'label' 	=> __('E-mail password', $ml_key),
				'type'		=> 'psw',
				'note'		=> __('Password to access the e-mail <strong>(FYI: is saved but not shown)</strong>', $ml_key),
				
				'js_vis'=> array(
					'linked_field' 	=> 'pcma_use_smtp',
					'condition'		=> true
				)
			),
			'pcma_use_smtp_auth' => array(
				'label' => __('Require SMTP authorization', $ml_key),
				'type'	=> 'checkbox',
				'note'	=> __('If checked, use the SMTP protocol to send e-mails (use only if required by your server)', $ml_key),
				
				'js_vis'=> array(
					'linked_field' 	=> 'pcma_use_smtp',
					'condition'		=> true
				)
			),
			'pcma_smtp_secure' => array(
				'label' => __("Security protocol", $ml_key),
				'type'	=> 'select',
				'val' 	=> array(
                    'none' => __('None', $ml_key), 
                    'ssl' => 'SSL', 
                    'tls' => 'TLS'
                ),
                'note'	=> __('For most servers, TLS is recommended. If server supports both protocols, TLS should be the right choice', $ml_key),
				
				'js_vis'=> array(
					'linked_field' 	=> 'pcma_use_smtp',
					'condition'		=> true
				)
			),
            'pcma_smtp_autotls' => array(
				'label' => __('Auto TLS?', $ml_key),
				'type'	=> 'checkbox',
				'note'	=> __('By default TLS encryption is automatically used if server supports it. However in some cases, due to server misconfigurations, it needs to be disabled', $ml_key),
				
				'js_vis'=> array(
					'linked_field' 	=> 'pcma_use_smtp',
					'condition'		=> true
				)
			),
		),
	),	
	
	
	'html_templates' => array(
		'sect_name'	=>  __('HTML Templates', $ml_key) . '<input type="button" name="pcma_add_mail_template" value="Add template" class="button-secondary"> ',
		'fields' 	=> array(
		
			'pcma_mail_templates' => array(
				'type'		=> 'message',
				'content'	=> '<div class="pc_spinner"></div>',
			),  
		),
	),	
);		



// mail tester
if(pcma_is_active()) {
	$structure['mail_config']['mail_tester'] = array(
		'sect_name'	=>  __('Test e-mail settings', $ml_key),
		'fields' 	=> array(
			
			'pcma_test_mail' => array(
				'label' 	=> __('Send a test e-mail to', $ml_key),
				'type'		=> 'text',
				'no_save'	=> true,
				'maxlen'	=> 100,
				'note'		=> __('E-mail test receiver', $ml_key),
			),	
			'pcma_test_mail_template' => array(
				'label' 	=> __('Use an e-mail template?', $ml_key),
				'type'		=> 'select',
				'val' 		=> pcma_get_mail_templates(),
				'no_save'	=> true,
			),	
			'pcma_test_mail_btn' => array(
				'type'		=> 'message',
				'content'	=> '<input type="button" id="pcma_test_btn" value="'. esc_attr__('Send E-mail', $ml_key) .'" class="button-secondary" /> <span id="pcma_test_result"></span>'
			),	
		),
	);
}



// USERS VERIFICATION
$structure['users_verif'] = array(
	'mv_enable' => array(
		'sect_name'	=>  __('Users Verification Through E-mail', $ml_key),
		'fields' 	=> array(
			
			'pcma_mv_enable' => array(
				'label' => __('Enable users verification?', $ml_key),
				'type'	=> 'checkbox',
				'note'	=> __("If checked, an-email will be sent to pending users to validate their e-mail address", $ml_key),
			),
            'pcma_mv_behav' => array(
				'label' 	=> __('Verification behavior', $ml_key),
				'type'		=> 'select',
				'val' 		=> array(
                    'activate'  => __('Automatically activate users', $ml_key),
                    'ignore'    => __('Ignore user status', $ml_key),
                ),
				'fullwidth'		=> true,
            ),
		),
	),
	
	'mv_landing_pag' => array(
		'sect_name'	=>  __('Landing Page Setup', $ml_key),
		'fields' 	=> array(
			
			'pcma_mv_pag' => array(
				'label' 	=> __('Choose a page', $ml_key),
				'type'		=> 'select',
				'val' 		=> $pages,
				'fullwidth' => true,
				'note'		=> __('Page to use as validation target. If opened directly, redicrects to the homepage. <strong class="lcwp_settings_rednote">Because of this, should be a brand new page!</strong>', $ml_key),
			),
            'pcma_mv_pag_behav' => array(
				'label' 	=> __('How to display messages?', $ml_key),
				'type'		=> 'select',
				'val' 		=> array(
                    'full_replace'  => __('Fully replace page contents', $ml_key),
                    'shortcode'     => __('Through shortcode', $ml_key),
                ),
				'note'		=> __('By default replaces the full page content. To better match with page builders you can use the <strong>[pcma-mv-pag-txt]</strong> shortcode', $ml_key),
            ),
			'pcma_mv_ok_mess' => array(
				'label' => __("Confirmation message", $ml_key) .'<p class="lcwp_sf_note">'. __('By default is: "Your account has been successfully activated!"', $ml_key) .'</p>',
				'type'	=> 'wp_editor',
				'rows' 	=> 2,
			), 
			'pcma_mv_act_mess' => array(
				'label' => __("Already active message", $ml_key) .'<p class="lcwp_sf_note">'. __('By default is: "Your account has been already activated!"', $ml_key) .'</p>',
				'type'	=> 'wp_editor',
				'rows' 	=> 2,
			), 
			'pcma_mv_bad_mess' => array(
				'label' => __("Error message", $ml_key) .'<p class="lcwp_sf_note">'. __('By default is: "Sorry, your request is invalid or your account has been deleted"', $ml_key) .'</p>',
				'type'	=> 'wp_editor',
				'rows' 	=> 2,
			), 
		),
	),
	
	'mv_mail_builder' => array(
		'sect_name'	=>  __('E-mail builder', $ml_key),
		'fields' 	=> array(
			
			'mv_legend' => pcma_phs_legend(
				array(
					'%SITE-TITLE%'	=> __('Website title specified in WP settings', $ml_key),
					'%NAME%'		=> __("User's name", $ml_key),
					'%SURNAME%'		=> __("User's surame", $ml_key),
					'%USERNAME%'	=> __("User's userame", $ml_key),
					'%TEL%'			=> __("User's telephone", $ml_key),
					'%PC-CAT%'			=> __("User categories", $ml_key),
					'%VER-URL%'		=> __("Verification URL", $ml_key).' <small class="lcwp_settings_rednote"><strong>('. __("mandatory in e-mail text", $ml_key).')'
				)
			),
			'pcma_mv_template' => array(
				'label' 	=> __("E-mail template", $ml_key),
				'type'		=> 'select',
				'val' 		=> pcma_get_mail_templates(),
				'fullwidth'	=> true,
			),
			'pcma_mv_subj' => array(
				'label' 	=> __('E-mail title', $ml_key),
				'type'		=> 'text',
				'def' 		=> $mail_texts['pcma_mv_subj'],
				'fullwidth' => true,
			),
			'pcma_mv_txt' => array(
				'label' => __("E-mail text", $ml_key),
				'type'	=> 'wp_editor',
				'def' 	=> $mail_texts['pcma_mv_txt'],
				'rows' 	=> 13,
			), 
		),
	),

	'manual_mv' => array(
		'sect_name'	=>  __('Manual E-mail Verification', $ml_key),
		'fields' 	=> array(
	
			'pcma_manual_mv_field' => array(
				'type'		=> 'custom',
				'callback'	=> 'pcma_manual_mv_field'
			), 
		),
	),
);



// ADMIN NOTIFIER
$structure['admin_notif'] = array(
	
	'pcma_admin_notif_main' => array(
		'sect_name'	=>  __('Common settings', $ml_key),
		'fields' 	=> array(
			
			'pcma_nnu_mail_multi' => array(
				'type'		=> 'custom',
				'callback'	=> 'pcma_nnu_mail_multi_field',
				'validation'=> array(
					array('index' => 'pcma_nnu_mail_multi', 'label' => __('Admin Notifier - e-mail address', $ml_key))
				)
			),
			'nnu_legend' => pcma_phs_legend(
				array(
					'%SITE-TITLE%'	=> __('Website title specified in WP settings', $ml_key),
					'%NAME%'		=> __("User's name", $ml_key),
					'%SURNAME%'		=> __("User's surame", $ml_key),
					'%USERNAME%'	=> __("User's userame", $ml_key),
					'%MAIL%'		=> __("User's e-mail", $ml_key),
					'%TEL%'			=> __("User's telephone", $ml_key),
					'%PC-CAT%'			=> __("User categories", $ml_key),
				)
			),
		),
	),
	
	
	'nnu_mail_builder' => array(
		'sect_name'	=>  __('New Users Notification', $ml_key),
		'fields' 	=> array(
			
			'pcma_nnu_enable' => array(
				'label' => __('Notify when new users register?', $ml_key),
				'type'	=> 'checkbox',
				'note'	=> __("If checked, send an e-mail when a new user registers", $ml_key),
			),
            'pcma_nnu_for_pc_admin' => array(
				'label' => __('Extend notification also for PrivateContent Admin users?', $ml_key),
				'type'	=> 'checkbox',
				'note'	=> __("If checked, the notification is sent also to PrivateContent admins if registered user can be managed by them", $ml_key),
			),
            'pcma_nnu_behav' => array(
				'label' 	=> __('Notification behavior', $ml_key),
				'type'		=> 'select',
				'val' 		=> array(
                    'always'        => __('Notify as soon as user registers', $ml_key),
                    'mail_verified' => __('Notify as soon as user verifies its e-mail', $ml_key),
                ),
				'fullwidth'		=> true,
            ),
			'pcma_nnu_template' => array(
				'label' 	=> __("E-mail template", $ml_key),
				'type'		=> 'select',
				'val' 		=> pcma_get_mail_templates(),
				'fullwidth'	=> true,
			),
			'pcma_nnu_subj' => array(
				'label' 	=> __('E-mail title', $ml_key),
				'type'		=> 'text',
				'def' 		=> $mail_texts['pcma_nnu_subj'],
				'fullwidth' => true,
			),
			'pcma_nnu_txt' => array(
				'label' => __("E-mail text", $ml_key),
				'type'	=> 'wp_editor',
				'def' 	=> $mail_texts['pcma_nnu_txt'],
				'rows' 	=> 13,
			), 
		),
	),
	
	'dun_mail_builder' => array(
		'sect_name'	=>  __('Deleted Users Notification', $ml_key),
		'fields' 	=> array(
			
			'pcma_dun_enable' => array(
				'label' => __('Notify deleted users?', $ml_key),
				'type'	=> 'checkbox',
				'note'	=> __("If checked, send an e-mail when a user self-deletes itself", $ml_key),
			),
            'pcma_dun_for_pc_admin' => array(
				'label' => __('Extend notification also for PrivateContent Admin uesrs?', $ml_key),
				'type'	=> 'checkbox',
				'note'	=> __("If checked, the notification is sent also to PrivateContent admins if deleted user can be managed by them", $ml_key),
			),
			'pcma_dun_template' => array(
				'label' 	=> __("E-mail template", $ml_key),
				'type'		=> 'select',
				'val' 		=> pcma_get_mail_templates(),
				'fullwidth'	=> true,
			),
			'pcma_dun_subj' => array(
				'label' 	=> __('E-mail title', $ml_key),
				'type'		=> 'text',
				'def' 		=> $mail_texts['pcma_dun_subj'],
				'fullwidth' => true,
			),
			'pcma_dun_txt' => array(
				'label' => __("E-mail text", $ml_key),
				'type'	=> 'wp_editor',
				'def' 	=> $mail_texts['pcma_dun_txt'],
				'rows' 	=> 7,
			), 
		),
	),
);



// APPROVED USER NOTIFIER
$structure['approved_notif'] = array(
	'pcma_nau_enable_switch' => array(
		'sect_name'	=>  __('Approved Users Notification', $ml_key),
		'fields' 	=> array(
			
			'pcma_nau_enable' => array(
				'label' => __('Notify approved users?', $ml_key),
				'type'	=> 'checkbox',
				'note'	=> __("If checked, an e-mail is sent to pending users as soon as they are approved by admins", $ml_key),
			),
		),
	),
	
	'nau_mail_builder' => array(
		'sect_name'	=>  __('E-mail builder', $ml_key),
		'fields' 	=> array(
			
			'nau_legend' => pcma_phs_legend(
				array(
					'%SITE-TITLE%'	=> __('Website title specified in WP settings', $ml_key),
					'%NAME%'		=> __("User's name", $ml_key),
					'%SURNAME%'		=> __("User's surame", $ml_key),
					'%USERNAME%'	=> __("User's userame", $ml_key),
					'%TEL%'			=> __("User's telephone", $ml_key),
					'%PC-CAT%'			=> __("User categories", $ml_key),
				)
			),
			'pcma_nau_template' => array(
				'label' 	=> __("E-mail template", $ml_key),
				'type'		=> 'select',
				'val' 		=> pcma_get_mail_templates(),
				'fullwidth'	=> true,
			),
			'pcma_nau_subj' => array(
				'label' 	=> __('E-mail title', $ml_key),
				'type'		=> 'text',
				'def' 		=> $mail_texts['pcma_nau_subj'],
				'fullwidth' => true,
			),
			'pcma_nau_txt' => array(
				'label' => __("E-mail text", $ml_key),
				'type'	=> 'wp_editor',
				'def' 	=> $mail_texts['pcma_nau_txt'],
				'rows' 	=> 13,
			), 
		),
	),
);



// WELCOME MESSAGE
$structure['welcome_mess'] = array(
	'pcma_wm_enable_switch' => array(
		'sect_name'	=>  __('Welcome message e-mail', $ml_key),
		'fields' 	=> array(
			
			'pcma_wm_enable' => array(
				'label' => __('E-mail registered users?', $ml_key),
				'type'	=> 'checkbox',
				'note'	=> __("If checked, sends a welcome e-mail to registered users", $ml_key),
			),
			'pcma_wm_receiver' => array(
				'label' => __("Send welcome message to", $ml_key),
				'type'	=> 'select',
				'val' 	=> array(
					'active_users' 	=> __("Only active users", $ml_key), 
					'any_user'		=> __("Any user", $ml_key)
				),
			),
		),
	),
	
	'wm_mail_builder' => array(
		'sect_name'	=>  __('E-mail builder', $ml_key),
		'fields' 	=> array(
			
			'wm_legend' => pcma_phs_legend(
				array(
					'%SITE-TITLE%'	=> __('Website title specified in WP settings', $ml_key),
					'%NAME%'		=> __("User's name", $ml_key),
					'%SURNAME%'		=> __("User's surame", $ml_key),
					'%USERNAME%'	=> __("User's userame", $ml_key),
					'%TEL%'			=> __("User's telephone", $ml_key),
					'%PC-CAT%'			=> __("User categories", $ml_key),
				)
			),
			'pcma_wm_template' => array(
				'label' 	=> __("E-mail template", $ml_key),
				'type'		=> 'select',
				'val' 		=> pcma_get_mail_templates(),
				'fullwidth'	=> true,
			),
			'pcma_wm_subj' => array(
				'label' 	=> __('E-mail title', $ml_key),
				'type'		=> 'text',
				'def' 		=> $mail_texts['pcma_wm_subj'],
				'fullwidth' => true,
			),
			'pcma_wm_txt' => array(
				'label' => __("E-mail text", $ml_key),
				'type'	=> 'wp_editor',
				'def' 	=> $mail_texts['pcma_wm_txt'],
				'rows' 	=> 13,
			), 
		),
	),
);



// GOODBYE MESSAGE
$structure['goodbye_mess'] = array(
	'pcma_gm_enable_switch' => array(
		'sect_name'	=>  __('Welcome message e-mail', $ml_key),
		'fields' 	=> array(
			
			'pcma_gm_enable' => array(
				'label' => __('E-mail users deleting their accounts?', $ml_key),
				'type'	=> 'checkbox',
				'note'	=> __("If checked, sends a goodbye e-mail to users self-deleting their accounts", $ml_key),
			),
		),
	),
	
	'gm_mail_builder' => array(
		'sect_name'	=>  __('E-mail builder', $ml_key),
		'fields' 	=> array(
			
			'gm_legend' => pcma_phs_legend(
				array(
					'%SITE-TITLE%'	=> __('Website title specified in WP settings', $ml_key),
					'%NAME%'		=> __("User's name", $ml_key),
					'%SURNAME%'		=> __("User's surame", $ml_key),
					'%USERNAME%'	=> __("User's userame", $ml_key),
					'%TEL%'			=> __("User's telephone", $ml_key),
					'%PC-CAT%'			=> __("User categories", $ml_key),
				)
			),
			'pcma_gm_template' => array(
				'label' 	=> __("E-mail template", $ml_key),
				'type'		=> 'select',
				'val' 		=> pcma_get_mail_templates(),
				'fullwidth'	=> true,
			),
			'pcma_gm_subj' => array(
				'label' 	=> __('E-mail title', $ml_key),
				'type'		=> 'text',
				'def' 		=> $mail_texts['pcma_gm_subj'],
				'fullwidth' => true,
			),
			'pcma_gm_txt' => array(
				'label' => __("E-mail text", $ml_key),
				'type'	=> 'wp_editor',
				'def' 	=> $mail_texts['pcma_gm_txt'],
				'rows' 	=> 13,
			), 
		),
	),
);



// IMPORT MESSAGE
$structure['import_mess'] = array(
	'pcma_niu_enable_switch' => array(
		'sect_name'	=>  __('Imported Users Notifier', $ml_key),
		'fields' 	=> array(
			
			'pcma_niu_enable' => array(
				'label' => __('Notify imported users?', $ml_key),
				'type'	=> 'checkbox',
				'note'	=> __("If checked, notifies imported users having an e-mail", $ml_key),
			),
		),
	),
	
	'niu_mail_builder' => array(
		'sect_name'	=>  __('E-mail builder', $ml_key),
		'fields' 	=> array(
			
			'niu_legend' => pcma_phs_legend(
				array(
					'%SITE-TITLE%'	=> __('Website title specified in WP settings', $ml_key),
					'%NAME%'		=> __("User's name", $ml_key),
					'%SURNAME%'		=> __("User's surame", $ml_key),
					'%USERNAME%'	=> __("User's userame", $ml_key),
					'%PSW%'			=> __("User's password", $ml_key),
					'%TEL%'			=> __("User's telephone", $ml_key),
					'%PC-CAT%'			=> __("User categories", $ml_key),
				)
			),
			'pcma_niu_template' => array(
				'label' 	=> __("E-mail template", $ml_key),
				'type'		=> 'select',
				'val' 		=> pcma_get_mail_templates(),
				'fullwidth'	=> true,
			),
			'pcma_niu_subj' => array(
				'label' 	=> __('E-mail title', $ml_key),
				'type'		=> 'text',
				'def' 		=> $mail_texts['pcma_nau_subj'],
				'fullwidth' => true,
			),
			'pcma_niu_txt' => array(
				'label' => __("E-mail text", $ml_key),
				'type'	=> 'wp_editor',
				'def' 	=> $mail_texts['pcma_nau_txt'],
				'rows' 	=> 13,
			), 
		),
	),
);



// PASSWORD RECOVERY
$structure['psw_recovery'] = array(
	'pcma_pr_enable_switch' => array(
		'sect_name'	=>  __('Password Recovery system', $ml_key),
		'fields' 	=> array(
			
			'pcma_psw_recovery' => array(
				'label' => __('Enable password recovery system?', $ml_key),
				'type'	=> 'checkbox',
				'note'	=> __("If checked, allows users to reset their password getting a new one via e-mail (through login form)", $ml_key),
			),
			'pcma_pr_with_email' => array(
				'label' => __('Allow recovery also through e-mail?', $ml_key),
				'type'	=> 'checkbox',
				'note'	=> __("If checked, allows users to recovery password also using their e-mail", $ml_key) .'<br/><strong class="lcwp_settings_rednote">'. __("Be sure database is ok with this: every user must have a unique e-mail", $ml_key) .'</strong>',
			),
            'pcma_safe_psw_recovery' => array(
				'label' => __('Enable safe mode?', $ml_key),
				'type'	=> 'checkbox',
				'note'	=> __("If checked, the new password will lasts only 20 minutes and user will be forced to change it at the first login.", $ml_key) .'<br/><strong>'. __('Requires User Data add-on - strongly suggested', $ml_key) .'</strong>',
                
                'def'   => (defined('PCUD_DIR')) ? 1 : false,
                'hide'  => (defined('PCUD_DIR')) ? false : true,
			),
		),
	),
	
	'pr_mail_builder' => array(
		'sect_name'	=>  __('E-mail builder', $ml_key),
		'fields' 	=> array(
			
			'pr_legend' => pcma_phs_legend(
				array(
					'%SITE-TITLE%'	=> __('Website title specified in WP settings', $ml_key),
					'%NAME%'		=> __("User's name", $ml_key),
					'%SURNAME%'		=> __("User's surame", $ml_key),
					'%USERNAME%'	=> __("User's userame", $ml_key),
					'%PSW%'			=> __("New Password", $ml_key) .'<small class="lcwp_settings_rednote"><strong>('. __("mandatory in e-mail text", $ml_key) .')</strong></small>',
					'%TEL%'			=> __("User's telephone", $ml_key),
					'%PC-CAT%'			=> __("User categories", $ml_key),
				)
			),
			'pcma_psw_mail_template' => array(
				'label' 	=> __("E-mail template", $ml_key),
				'type'		=> 'select',
				'val' 		=> pcma_get_mail_templates(),
				'fullwidth'	=> true,
			),
			'pcma_psw_mail_subj' => array(
				'label' 	=> __('E-mail title', $ml_key),
				'type'		=> 'text',
				'def' 		=> $mail_texts['pcma_psw_mail_subj'],
				'fullwidth' => true,
			),
			'pcma_psw_mail_txt' => array(
				'label' => __("E-mail text", $ml_key),
				'type'	=> 'wp_editor',
				'def' 	=> $mail_texts['pcma_psw_mail_txt'],
				'rows' 	=> 13,
			), 
		),
	),
);



// USER PVT PAGE UPDATE NOTIF
$structure['user_pp_update_notif'] = array(
	'uppu_mail_builder' => array(
		'sect_name'	=>  __('E-mail builder', $ml_key),
		'fields' 	=> array(
			
			'uppu_legend' => pcma_phs_legend(
				array(
					'%SITE-TITLE%'	=> __('Website title specified in WP settings', $ml_key),
					'%NAME%'		=> __("User's name", $ml_key),
					'%SURNAME%'		=> __("User's surame", $ml_key),
					'%USERNAME%'	=> __("User's userame", $ml_key),
					'%TEL%'			=> __("User's telephone", $ml_key),
					'%PC-CAT%'		=> __("User categories", $ml_key),
                    '%PAGE-URL%'    => __("Private page URL", $ml_key),
				)
			),
			'pcma_uppu_mail_template' => array(
				'label' 	=> __("E-mail template", $ml_key),
				'type'		=> 'select',
				'val' 		=> pcma_get_mail_templates(),
				'fullwidth'	=> true,
			),
			'pcma_uppu_mail_subj' => array(
				'label' 	=> __('E-mail title', $ml_key),
				'type'		=> 'text',
				'def' 		=> $mail_texts['pcma_uppu_mail_subj'],
				'fullwidth' => true,
			),
			'pcma_uppu_mail_txt' => array(
				'label' => __("E-mail text", $ml_key),
				'type'	=> 'wp_editor',
				'def' 	=> $mail_texts['pcma_uppu_mail_txt'],
				'rows' 	=> 13,
			), 
		),
	),
);



// MAILCHIMP
include_once(PCMA_DIR .'/classes/mailchimp_integration.php');
			
// get mailchimp lists
$mc = new pcma_mailchimp();
$mc_lists = ($mc->is_ready(true)) ? $mc->get_lists() : array();

$mc_lists_final = array('' => esc_html__("none", $ml_key));
foreach($mc_lists as $list) {
	$mc_lists_final[ $list['id'] ] = $list['name'];
}

// manual-sync text
$manual_sync_text = '
<input type="button" id="pcma_mc_sync" value="'. esc_attr__('Manual Sync', $ml_key) .'" class="button-secondary" />
<div id="pcma_mc_sync_result"></div>';

$interests = get_option('pcma_interests');
if(empty($interests)) {
	$manual_sync_text .= '
	<p id="pcma_mc_sync_required">
		<strong class="lcwp_settings_rednote">'. __('IMPORTANT - no caterories synced yet. Manual sync required!', $ml_key) .'</strong>
	</p>';	
}


$structure['mailchimp'] = array(
	'mailchimp_config' => array(
		'sect_name'	=>  __('Mailchimp Integration', $ml_key),
		'fields' 	=> array(
			
			'pcma_mc_apikey' => array(
				'label' 	=> __("Api Key", $ml_key) .' (<a href="http://kb.mailchimp.com/article/where-can-i-find-my-api-key" target="_blank">'. __("How to get it?", $ml_key) .'</a>)',
				'type'		=> 'text',
				'maxlen'	=> 40,
				'fullwidth' => true,
			),
			
			'pcma_mc_list' => array(
				'label' => __("Target list", $ml_key),
				'type'	=> 'select',
				'hide'	=> (empty($mc_lists)) ? true : false, 
				'val' 	=> $mc_lists_final,
				'note'	=> __("Select the list you want to use for sync (should <strong>NOT</strong> be changed in future)", $ml_key)
			),
			'pcma_mc_auto_sync' => array(
				'label' => __('Auto-sync?', $ml_key),
				'type'	=> 'checkbox',
				'hide'	=> (empty($mc_lists)) ? true : false, 
				'note'	=> __("If checked, performs sync when a user is added or removed", $ml_key),
			),
			'pcma_mc_sync_all' => array(
				'label' => __('Sync also extra fields?', $ml_key),
				'type'	=> 'checkbox',
				'hide'	=> (empty($mc_lists)) ? true : false, 
				'note'	=> __("If checked, syncs any user's data into mailchimp's database", $ml_key),
			),
			'pcma_mc_def_discl' => array(
				'label' => __('Subscribe new users by default?', $ml_key),
				'type'	=> 'checkbox',
				'hide'	=> (empty($mc_lists)) ? true : false, 
				'note'	=> __("If checked and <strong>no disclaimer is used in registration form</strong>, subscribes new users", $ml_key),
			),
			'spcr1' => array(
				'type' => 'spacer',
				'hide'	=> (empty($mc_lists)) ? true : false, 
			),
			'pcma_mc_discl_txt' => array(
				'label' 	=> __("Form disclaimer's text", $ml_key),
				'type'		=> 'text',
				'def'		=> __('I want to receive periodical newsletters', $ml_key),
				'fullwidth' => true,
				'hide'	=> (empty($mc_lists)) ? true : false, 
			),
			'pcma_mc_unsub_hook' => array(
				'label' 	=> __("Unsubscribe user - Webhook URL", $ml_key) .' (<a href="http://kb.mailchimp.com/integrations/api-integrations/how-to-set-up-webhooks#Set-Up-WebHooks" target="_blank">'. __("How to set it?", $ml_key) .'</a>)',
				'type'		=> 'label_message',
				'content'	=> '<p  class="pcma_mc_unsubscribe_url">'. trailingslashit( get_home_url()) .'?pcma_mc_unsubscribe</p>',
				'hide'	=> (empty($mc_lists)) ? true : false, 
			),
			
			'spcr2' => array(
				'type' => 'spacer',
			),
			'mc_warn' => array(
				'type' 		=> 'message',
				'content'	=> (empty($mc_lists) || get_option('pcma_mc_list')) ? __("Insert a valid API key and save settings to choose a list. A list must exists on your MailChimp account", $ml_key) : __("Choose a list and save settings to start using sync system", $ml_key),
				'hide'	=> ($mc->is_ready()) ? true : false, 
			),
			'mc_manual_sync' => array(
				'type' 		=> 'message',
				'content'	=> $manual_sync_text,
				'hide'	=> ($mc->is_ready()) ? false : true, 
			)
		),
	),
);


// PCMA-FILTER - manipulate settings structure
$GLOBALS['pcma_settings_structure'] = apply_filters('pcma_settings_structure', $structure);
